﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
    <title>Rozliczenia - podejrzane księgowania</title>
    <script runat="server">
    void Grid1_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args) {
      RozrachunekIdx idx = (RozrachunekIdx)args.Row;
      ZapisKsiegowy zk = (ZapisKsiegowy)((IElementKsiegowalny)idx.Dokument).ZapisKsiegowy;
      colZapis.EditValue = zk.Numer;
      colKonto.EditValue = zk.Konto;
      colEwidencja.EditValue = zk.Dekret.Ewidencja;
    }
    
    PowiazaniaKont pk = null;
    
    RozrachunkiIdxViewInfoParams pars = null; 
	  [Soneta.Business.Context(Required=true)] 
	  public RozrachunkiIdxViewInfoParams Params { 
		  get { return pars; } 
		  set { pars = value; } 
	  } 
    
    void PodejrzaneKsiegowania_OnLoad(Object sender, EventArgs args){
          
      Row[] rows = (Row[])DataContext1.Get(typeof(Row[]));
      
      ReportHeader1.Title = 
        string.Format(ReportHeader1.Title, pars.Podmiot, pars.Indeks, pars.Dokumenty, pars.Okres, pars.Aktualny);

      pk = KsiegaModule.GetInstance(DataContext1.Session).PowiazaniaKont;
      
      ArrayList arr = new ArrayList();
      foreach(RozrachunekIdx idx in rows){
        IElementKsiegowalny ek = (IElementKsiegowalny)idx.Dokument;
        IPodmiot p = idx.Podmiot;
        ZapisKsiegowy zk = (ZapisKsiegowy)ek.ZapisKsiegowy;
        
        if(zk==null)
          continue;
          
        KontoBase k = zk.Konto;
        KontoBase ks = k.Nadrzedne;
        if(ks==null){
          arr.Add(idx);
          continue;
        }
          
        if(ks.Slownik==null){
          arr.Add(idx);
          continue;
        }
          
        bool add = true;
        IElementSlownika es = (IElementSlownika)p;
        foreach(PowiazanieKontaBase pow in pk.WgKontoSlownikowe[ks,es]){
          if(pow.Typ==TypPowiazania.Slownikowe && pow.Konto==k){
            add = false;
            break;
          }
        }
        
        if(add)
          arr.Add(idx);
        
      }
      
      Grid1.DataSource = arr;
    }
    </script>
    
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
  </HEAD>
  <body>
    <form id="PodejrzaneKsiegowania" method="post" runat="server" onload="PodejrzaneKsiegowania_OnLoad">
      <P><ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:datacontext>
        <cc1:ReportHeader id="ReportHeader1" title="Rozliczenia - podejrzane księgowania | Podmiot: {0},  | Index: {1}, Dokumenty: {2} | Okres: {3}, Aktualny: {4}" runat="server"></cc1:ReportHeader><BR>
        <ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_OnBeforeRow" RowTypeName="Soneta.Kasa.RozrachunekIdx,Soneta.Kasa" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True">
          <Columns>
            <ea:GridColumn Width="15" Caption="Nr ewidencji" ID="colEwidencja"></ea:GridColumn>
            <ea:GridColumn Width="15" DataMember="Numer" Caption="Nr dokumentu"></ea:GridColumn>
            <ea:GridColumn Width="12" Align="Center" DataMember="Data" Caption="Data dok."></ea:GridColumn>
            <ea:GridColumn DataMember="Podmiot" Caption="Podmiot dok."></ea:GridColumn>
            <ea:GridColumn Width="15" Caption="Nr zapisu" ID="colZapis"></ea:GridColumn>
            <ea:GridColumn Caption="Konto" ID="colKonto"></ea:GridColumn>
          </Columns>
        </ea:grid>
        <cc1:ReportFooter id="ReportFooter1" runat="server">
          <Subtitles>
            <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
          </Subtitles>
        </cc1:ReportFooter></P>
    </form>
  </body>
</HTML>

